// AppDlg.cpp : implementation file
//

#include "stdafx.h"
#include "App.h"
#include "AppDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CAppDlg dialog




CAppDlg::CAppDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAppDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CAppDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT1, edit1);
	DDX_Control(pDX, IDC_EDIT2, edit2);
	DDX_Control(pDX, IDC_SLIDER1, slider1);
	DDX_Control(pDX, IDC_SLIDER2, slider2);
	DDX_Control(pDX, IDC_SLIDER3, slider3);
	DDX_Control(pDX, IDC_SLIDER4, slider4);
}

BEGIN_MESSAGE_MAP(CAppDlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BUTTON1, &CAppDlg::OnBnClickedButton1)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER1, &CAppDlg::OnNMCustomdrawSlider1)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER2, &CAppDlg::OnNMCustomdrawSlider1)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER3, &CAppDlg::OnNMCustomdrawSlider1)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER4, &CAppDlg::OnNMCustomdrawSlider1)
	ON_EN_CHANGE(IDC_EDIT2, &CAppDlg::OnEnChangeEdit2)
END_MESSAGE_MAP()


// CAppDlg message handlers

BOOL CAppDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	uchwytOkna = 0;
	trwaOdczytywanieWlasnosciOkna = false;
	CString textOkna;
	textOkna.AppendFormat(L"%d",GetCurrentProcessId());
	edit1.SetWindowTextW(textOkna);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CAppDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CAppDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void CAppDlg::OnBnClickedButton1()
{
	const int MAX_COUNT=256;

	wchar_t nazwaOkna[MAX_COUNT];
	trwaOdczytywanieWlasnosciOkna=true;
	unsigned long processId=0;
	try
	{
		CString processIdStr;
		edit1.GetWindowTextW(processIdStr);
		processId=_wtoi(processIdStr);
	}
	catch(...)
	{
		MessageBox(L"Identyfikator procesu musi by liczb");
		return;
	}

	uchwytOkna=PobierzUchwytGlownegoOkna(processId);
	bool prawidlowyPID=(uchwytOkna!=0);

	slider1.EnableWindow(prawidlowyPID);
	slider2.EnableWindow(prawidlowyPID);
	slider3.EnableWindow(prawidlowyPID);
	slider4.EnableWindow(prawidlowyPID);
	edit2.EnableWindow(prawidlowyPID);

	if (prawidlowyPID)
	{
		//Odczytywanie tytulu okna
		::GetWindowText(uchwytOkna,nazwaOkna,MAX_COUNT);
		edit2.SetWindowTextW(nazwaOkna);

		//Odczytywanie polozenia okna
		WINDOWPLACEMENT ustawieniaOkna;
		::GetWindowPlacement(uchwytOkna,&ustawieniaOkna);

		int x=ustawieniaOkna.rcNormalPosition.left;
		int y=ustawieniaOkna.rcNormalPosition.top;
		int szer=ustawieniaOkna.rcNormalPosition.right-x;
		int wys=ustawieniaOkna.rcNormalPosition.bottom-y;

		int szerMonitora = ::GetSystemMetrics(SM_CXSCREEN);
		int wysMonitora = ::GetSystemMetrics(SM_CYSCREEN);

		//ujemna pozycja nie jest uwzgledniana
		slider1.SetRangeMax(szerMonitora);
		slider2.SetRangeMax(wysMonitora);
		slider3.SetRangeMax(szerMonitora);
		slider4.SetRangeMax(wysMonitora);
		slider1.SetPos(szer);
		slider2.SetPos(wys);
		slider3.SetPos(x);
		slider4.SetPos(y);

	}
	else MessageBox(L"Proces o podanym numerze PID nie istnieje");

	trwaOdczytywanieWlasnosciOkna=false;

}

void CAppDlg::OnNMCustomdrawSlider1(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMCUSTOMDRAW pNMCD = reinterpret_cast<LPNMCUSTOMDRAW>(pNMHDR);
	// TODO: Add your control notification handler code here
	*pResult = 0;

	if(uchwytOkna == 0 || trwaOdczytywanieWlasnosciOkna)
		return;
	
	WINDOWPLACEMENT ustawieniaOkna;
	ustawieniaOkna.rcNormalPosition.left = slider3.GetPos();
	ustawieniaOkna.rcNormalPosition.top = slider4.GetPos();
	ustawieniaOkna.rcNormalPosition.right = slider3.GetPos()+slider1.GetPos();
	ustawieniaOkna.rcNormalPosition.bottom = slider4.GetPos()+slider2.GetPos();

	ustawieniaOkna.showCmd = SW_RESTORE;
	ustawieniaOkna.length = sizeof(ustawieniaOkna);
	::SetWindowPlacement(uchwytOkna,&ustawieniaOkna);
}

void CAppDlg::OnEnChangeEdit2()
{
	if(uchwytOkna == 0 || trwaOdczytywanieWlasnosciOkna)
		return;

	CString tytulOkna;
	edit2.GetWindowTextW(tytulOkna);
	::SetWindowText(uchwytOkna,tytulOkna);
}
